//note to self: hydration level is the weight of water divided by the weight of the flour
//measurements regarding bread baking are almost always done in grams for accuracy, but I think it would be useful to include a feature that allows the user to calculate from cups. So they would toggle "calculate from cups" and then input their values. 
function checkForm() {
  let flour = document.getElementById("flour").value;
  let water = document.getElementById("water").value;
  let toggle = document.querySelector("input[type='checkbox']"); 

//check for valid input
  if(isNaN(flour) || isNaN(water) || flour <= 0 || water <= 0) {
    alert("Brevity is the soul of wit, but please enter a valid number!");
    return;
  }

// calculate from cups by taking the inputted value and converting to grams
  if (toggle.checked) {
    flour = flour * 120;
    water = water * 240;
  }
  let result = document.getElementById("result");
  let hydration = (water / flour) * 100; 
  let text = "Your loaf's hydration level is " + hydration.toFixed(1) + "%"; 
  result.innerHTML = text;
}



